/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.lib.sonar.sonar.common.valuecontainer;

import com.minecraftabnormals.abnormals_core.lib.sonar.sonar.common.valuecontainer.ToggleEntry;
import com.minecraftabnormals.abnormals_core.lib.sonar.sonar.common.valuecontainer.ValueContainerEntry;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;

public class BooleanValueContainerEntry
implements ValueContainerEntry<Boolean>,
ToggleEntry {
    private final ITextComponent displayName;
    private final String name;
    private final Boolean previousValue;
    private Boolean value;
    private Predicate<String> validator;
    private boolean toggle;

    public BooleanValueContainerEntry(ITextComponent displayName, String name, boolean value) {
        this.displayName = displayName;
        this.name = name;
        this.previousValue = value;
        this.value = value;
        this.validator = BooleanValueContainerEntry.createDefaultValidator();
        this.toggle = true;
    }

    @Override
    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ValueContainerEntry.InputType getInputType() {
        return this.toggle ? ValueContainerEntry.InputType.TOGGLE : ValueContainerEntry.InputType.TEXT_FIELD;
    }

    @Override
    public <E> E getValue() {
        return (E)this.value;
    }

    @Override
    public <E> E getPreviousValue() {
        return (E)this.previousValue;
    }

    @Override
    public boolean isDirty() {
        return this.value.booleanValue() != this.previousValue.booleanValue();
    }

    @Override
    public String getDisplay() {
        return Boolean.toString(this.value);
    }

    @Override
    public Optional<Predicate<String>> getValidator() {
        return Optional.ofNullable(this.validator);
    }

    public BooleanValueContainerEntry setValidator(@Nullable Predicate<String> validator) {
        this.validator = validator;
        return this;
    }

    @Override
    public void write(CompoundNBT nbt) {
        nbt.func_74757_a(this.getName(), this.value.booleanValue());
    }

    @Override
    public void read(CompoundNBT nbt) {
        this.value = nbt.func_150297_b(this.getName(), 1) ? nbt.func_74767_n(this.getName()) : this.previousValue.booleanValue();
    }

    @Override
    public void parse(String data) {
        this.value = Boolean.parseBoolean(data);
    }

    @Override
    public boolean isToggled() {
        return this.value;
    }

    public BooleanValueContainerEntry setToggle(boolean toggle) {
        this.toggle = toggle;
        return this;
    }

    public static Predicate<String> createDefaultValidator() {
        return s -> "true".equalsIgnoreCase((String)s) || "false".equalsIgnoreCase((String)s);
    }
}

